<?php
if (!defined('ABSPATH')) { exit; }

global $wpdb;

/**
 * NOTE: This file is included as a view; keep variables prefixed to avoid global naming warnings.
 */
$aegisseo_table_404 = $wpdb->prefix . 'aegisseo_404';
// Hard-sanitize the table identifier (prefix is trusted but Plugin Check flags dynamic identifiers).
$aegisseo_table_404 = preg_replace('/[^A-Za-z0-9_]/', '', (string) $aegisseo_table_404);

/**
 * Filter params (GET). Nonce is recommended even for read-only filtering in wp-admin.
 * If nonce is missing/invalid, ignore filter inputs to avoid processing unverified form data.
 */
$aegisseo_filters_nonce = isset($_REQUEST['_aegisseo_404_nonce']) ? sanitize_text_field(wp_unslash($_REQUEST['_aegisseo_404_nonce'])) : '';
$aegisseo_has_filter_input = isset($_GET['s']) || isset($_GET['min_hits']) || isset($_GET['p']);

if ($aegisseo_has_filter_input && (empty($aegisseo_filters_nonce) || !wp_verify_nonce($aegisseo_filters_nonce, 'aegisseo_404_filters'))) {
    $aegisseo_search   = '';
    $aegisseo_min_hits = 0;
    $aegisseo_page     = 1;
} else {
    $aegisseo_search   = isset($_GET['s']) ? sanitize_text_field(wp_unslash($_GET['s'])) : '';
    $aegisseo_min_hits = isset($_GET['min_hits']) ? absint(wp_unslash($_GET['min_hits'])) : 0;
    $aegisseo_page     = isset($_GET['p']) ? max(1, absint(wp_unslash($_GET['p']))) : 1;
}

$aegisseo_per_page = 25;
$aegisseo_offset   = ($aegisseo_page - 1) * $aegisseo_per_page;

/**
 * Build SQL safely.
 * IMPORTANT: Plugin Checker flags dynamic SQL fragments/variables even if prepared.
 * To satisfy it, we use fixed SQL strings per condition (no concatenation, no SQL vars).
 */
$aegisseo_like = '';
if ($aegisseo_search !== '') {
    $aegisseo_like = '%' . $wpdb->esc_like((string) $aegisseo_search) . '%';
}

// Cache count query (admin pages can get hammered via pagination/search).
$aegisseo_cache_key_count = 'aegisseo_404_count_' . md5($aegisseo_table_404 . '|' . (string) $aegisseo_search . '|' . (int) $aegisseo_min_hits);
$aegisseo_total = wp_cache_get($aegisseo_cache_key_count, 'aegisseo');
if ($aegisseo_total === false) {
    if ($aegisseo_search !== '' && $aegisseo_min_hits > 0) {
        $aegisseo_total = (int) $wpdb->get_var( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
            $wpdb->prepare(
                "SELECT COUNT(*) FROM %i WHERE url LIKE %s AND hits >= %d",
                $aegisseo_table_404,
                $aegisseo_like,
                (int) $aegisseo_min_hits
            )
        );
    } elseif ($aegisseo_search !== '') {
        $aegisseo_total = (int) $wpdb->get_var( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
            $wpdb->prepare(
                "SELECT COUNT(*) FROM %i WHERE url LIKE %s",
                $aegisseo_table_404,
                $aegisseo_like
            )
        );
    } elseif ($aegisseo_min_hits > 0) {
        $aegisseo_total = (int) $wpdb->get_var( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
            $wpdb->prepare(
                "SELECT COUNT(*) FROM %i WHERE hits >= %d",
                $aegisseo_table_404,
                (int) $aegisseo_min_hits
            )
        );
    } else {
        // No filters.
        $aegisseo_total = (int) $wpdb->get_var( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
            $wpdb->prepare(
                "SELECT COUNT(*) FROM %i WHERE 1=%d",
                $aegisseo_table_404,
                1
            )
        );
    }
    wp_cache_set($aegisseo_cache_key_count, $aegisseo_total, 'aegisseo', 60);
}
$aegisseo_total = (int) $aegisseo_total;

$aegisseo_cache_key_list = 'aegisseo_404_list_' . md5($aegisseo_table_404 . '|' . (string) $aegisseo_search . '|' . (int) $aegisseo_min_hits . '|' . (int) $aegisseo_per_page . '|' . (int) $aegisseo_offset);
$aegisseo_rows = wp_cache_get($aegisseo_cache_key_list, 'aegisseo');
if ($aegisseo_rows === false) {
    if ($aegisseo_search !== '' && $aegisseo_min_hits > 0) {
        $aegisseo_rows = $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
            $wpdb->prepare(
                "SELECT * FROM %i WHERE url LIKE %s AND hits >= %d ORDER BY last_seen DESC LIMIT %d OFFSET %d",
                $aegisseo_table_404,
                $aegisseo_like,
                (int) $aegisseo_min_hits,
                (int) $aegisseo_per_page,
                (int) $aegisseo_offset
            ),
            ARRAY_A
        );
    } elseif ($aegisseo_search !== '') {
        $aegisseo_rows = $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
            $wpdb->prepare(
                "SELECT * FROM %i WHERE url LIKE %s ORDER BY last_seen DESC LIMIT %d OFFSET %d",
                $aegisseo_table_404,
                $aegisseo_like,
                (int) $aegisseo_per_page,
                (int) $aegisseo_offset
            ),
            ARRAY_A
        );
    } elseif ($aegisseo_min_hits > 0) {
        $aegisseo_rows = $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
            $wpdb->prepare(
                "SELECT * FROM %i WHERE hits >= %d ORDER BY last_seen DESC LIMIT %d OFFSET %d",
                $aegisseo_table_404,
                (int) $aegisseo_min_hits,
                (int) $aegisseo_per_page,
                (int) $aegisseo_offset
            ),
            ARRAY_A
        );
    } else {
        // No filters.
        $aegisseo_rows = $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
            $wpdb->prepare(
                "SELECT * FROM %i ORDER BY last_seen DESC LIMIT %d OFFSET %d",
                $aegisseo_table_404,
                (int) $aegisseo_per_page,
                (int) $aegisseo_offset
            ),
            ARRAY_A
        );
    }
    wp_cache_set($aegisseo_cache_key_list, $aegisseo_rows, 'aegisseo', 60);
}

$aegisseo_total_pages = max(1, (int) ceil($aegisseo_total / $aegisseo_per_page));

$aegisseo_base = remove_query_arg(array('p'));
?>
<div class="aegisseo-panel">
    <h3 style="margin-top:0;"><?php echo esc_html__('404 Monitor', 'aegisseo'); ?></h3>
	<?php
	$plugin = \AegisSEO\Plugin::instance();
	$aegisseo_opts = $plugin->options->get_all();
	?>

	<div class="aegisseo-box">
	  <h3><?php echo esc_html__('SEO Alerts (Evidence-Based)', 'aegisseo'); ?></h3>
	  <p class="aegisseo-help">
		<?php echo esc_html__('Alerts use your stored Search Console snapshots to detect drops (last 7 days vs previous 7 days).', 'aegisseo'); ?>
	  </p>

	  <form method="post" action="options.php">
		<?php settings_fields('aegisseo_settings_group'); ?>

		<label>
		  <input type="checkbox" name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[alerts_enabled]" value="1" <?php checked(!empty($aegisseo_opts['alerts_enabled'])); ?> />
		  <?php echo esc_html__('Enable Alerts', 'aegisseo'); ?>
		</label>

		<div class="aegisseo-inline-row">
		  <div>
			<label style="font-weight:600;"><?php echo esc_html__('Recipients', 'aegisseo'); ?></label><br/>
			<input type="text"
			  style="min-width:420px;"
			  name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[alerts_emails]"
			  value="<?php echo esc_attr($aegisseo_opts['alerts_emails'] ?? ''); ?>"
			  placeholder="email1@domain.com, email2@domain.com" />
			<p class="aegisseo-help"><?php echo esc_html__('Comma or space separated.', 'aegisseo'); ?></p>
		  </div>
		</div>

		<div class="aegisseo-inline-row">
		  <div>
			<label style="font-weight:600;"><?php echo esc_html__('Clicks drop %', 'aegisseo'); ?></label><br/>
			<input type="number" min="5" max="95"
			  name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[alerts_drop_clicks_pct]"
			  value="<?php echo esc_attr((int)($aegisseo_opts['alerts_drop_clicks_pct'] ?? 35)); ?>" />
		  </div>

		  <div>
			<label style="font-weight:600;"><?php echo esc_html__('Impressions drop %', 'aegisseo'); ?></label><br/>
			<input type="number" min="5" max="95"
			  name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[alerts_drop_impressions_pct]"
			  value="<?php echo esc_attr((int)($aegisseo_opts['alerts_drop_impressions_pct'] ?? 35)); ?>" />
		  </div>

		  <div>
			<label style="font-weight:600;"><?php echo esc_html__('CTR drop %', 'aegisseo'); ?></label><br/>
			<input type="number" min="5" max="95"
			  name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[alerts_drop_ctr_pct]"
			  value="<?php echo esc_attr((int)($aegisseo_opts['alerts_drop_ctr_pct'] ?? 25)); ?>" />
		  </div>

		  <div>
			<label style="font-weight:600;"><?php echo esc_html__('Position worse by', 'aegisseo'); ?></label><br/>
			<input type="number" step="0.1" min="0.5" max="20"
			  name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[alerts_position_worse]"
			  value="<?php echo esc_attr((float)($aegisseo_opts['alerts_position_worse'] ?? 2.0)); ?>" />
		  </div>
		</div>

		<?php submit_button(__('Save Alerts Settings', 'aegisseo')); ?>
	  </form>

	  <hr/>

	  <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
		<?php wp_nonce_field('aegisseo_send_test_alert'); ?>
		<input type="hidden" name="action" value="aegisseo_send_test_alert" />
		<?php submit_button(__('Send Test Alert Email', 'aegisseo'), 'secondary', 'submit', false); ?>
	  </form>
	</div>

    <form method="get" action="<?php echo esc_url(admin_url('admin.php')); ?>" style="margin: 0 0 14px 0;">
        <input type="hidden" name="page" value="aegisseo" />
        <input type="hidden" name="tab" value="404" />
        <?php wp_nonce_field('aegisseo_404_filters', '_aegisseo_404_nonce', false); ?>
        <input type="text" name="s" value="<?php echo esc_attr($aegisseo_search); ?>" placeholder="<?php echo esc_attr__('Search URL…', 'aegisseo'); ?>" style="min-width:280px;" />
        <input type="number" name="min_hits" value="<?php echo esc_attr($aegisseo_min_hits); ?>" placeholder="<?php echo esc_attr__('Min hits', 'aegisseo'); ?>" style="width:120px;" />
        <button class="button"><?php echo esc_html__('Filter', 'aegisseo'); ?></button>
        <a class="button" href="<?php echo esc_url(admin_url('admin.php?page=aegisseo&tab=404')); ?>"><?php echo esc_html__('Reset', 'aegisseo'); ?></a>
    </form>

    <div style="display:flex; gap:8px; flex-wrap:wrap; margin: 0 0 14px 0;">
        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
            <?php wp_nonce_field('aegisseo_404_export'); ?>
            <input type="hidden" name="action" value="aegisseo_404_export" />
            <button class="button"><?php echo esc_html__('Export CSV', 'aegisseo'); ?></button>
        </form>

        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" onsubmit="return confirm('<?php echo esc_js(__('Clear all 404 records?', 'aegisseo')); ?>');">
            <?php wp_nonce_field('aegisseo_404_clear'); ?>
            <input type="hidden" name="action" value="aegisseo_404_clear" />
            <button class="button button-secondary"><?php echo esc_html__('Clear', 'aegisseo'); ?></button>
        </form>

        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
            <?php wp_nonce_field('aegisseo_404_prune'); ?>
            <input type="hidden" name="action" value="aegisseo_404_prune" />
            <button class="button button-secondary"><?php echo esc_html__('Prune Now', 'aegisseo'); ?></button>
        </form>
    </div>

    <table class="widefat striped">
        <thead>
            <tr>
                <th style="width:38%;"><?php echo esc_html__('URL', 'aegisseo'); ?></th>
                <th style="width:8%;"><?php echo esc_html__('Hits', 'aegisseo'); ?></th>
                <th style="width:14%;"><?php echo esc_html__('First seen', 'aegisseo'); ?></th>
                <th style="width:14%;"><?php echo esc_html__('Last seen', 'aegisseo'); ?></th>
                <th style="width:18%;"><?php echo esc_html__('Referrer', 'aegisseo'); ?></th>
                <th style="width:8%;"><?php echo esc_html__('Actions', 'aegisseo'); ?></th>
            </tr>
        </thead>
        <tbody>
        <?php if (empty($aegisseo_rows)) : ?>
            <tr><td colspan="6"><?php echo esc_html__('No 404 records found.', 'aegisseo'); ?></td></tr>
        <?php else : ?>
            <?php foreach ($aegisseo_rows as $aegisseo_r) : ?>
                <?php
                    $aegisseo_url = isset($aegisseo_r['url']) ? (string) $aegisseo_r['url'] : '';
                    $aegisseo_hits = isset($aegisseo_r['hits']) ? (int) $aegisseo_r['hits'] : 0;
                    $aegisseo_first = isset($aegisseo_r['first_seen']) ? (string) $aegisseo_r['first_seen'] : '';
                    $aegisseo_last = isset($aegisseo_r['last_seen']) ? (string) $aegisseo_r['last_seen'] : '';
                    $aegisseo_ref = isset($aegisseo_r['referrer']) ? (string) $aegisseo_r['referrer'] : '';
                    $aegisseo_create_url = admin_url('admin.php?page=aegisseo&tab=redirects&from404=' . rawurlencode($aegisseo_url));
                ?>
                <tr>
                    <td>
                        <code><?php echo esc_html($aegisseo_url); ?></code>
                        <?php if (!empty($aegisseo_r['ip'])) : ?>
                            <div style="color:#666; font-size:12px;"><?php echo esc_html__('IP:', 'aegisseo'); ?> <?php echo esc_html((string)$aegisseo_r['ip']); ?></div>
                        <?php endif; ?>
                    </td>
                    <td><?php echo esc_html($aegisseo_hits); ?></td>
                    <td><?php echo esc_html($aegisseo_first); ?></td>
                    <td><?php echo esc_html($aegisseo_last); ?></td>
                    <td>
                        <?php if ($aegisseo_ref) : ?>
                            <span title="<?php echo esc_attr($aegisseo_ref); ?>"><?php echo esc_html(mb_strlen($aegisseo_ref) > 48 ? mb_substr($aegisseo_ref, 0, 48) . '…' : $aegisseo_ref); ?></span>
                        <?php else : ?>
                            <span style="color:#666;">—</span>
                        <?php endif; ?>
                    </td>
                    <td><a class="button button-small" href="<?php echo esc_url($aegisseo_create_url); ?>"><?php echo esc_html__('Redirect', 'aegisseo'); ?></a></td>
                </tr>
            <?php endforeach; ?>
        <?php endif; ?>
        </tbody>
    </table>

    <?php if ($aegisseo_total_pages > 1) : ?>
        <div style="margin-top: 12px;">
            <span class="description"><?php
                /* translators: 1: current page number, 2: total pages */
                echo esc_html(sprintf(__('Page %1$d of %2$d', 'aegisseo'), $aegisseo_page, $aegisseo_total_pages));
            ?></span>
            <div style="margin-top:6px;">
                <?php for ($aegisseo_i=1; $aegisseo_i<=$aegisseo_total_pages; $aegisseo_i++) : ?>
                    <?php
                        $aegisseo_u = add_query_arg('p', $aegisseo_i, $aegisseo_base);
                        $aegisseo_cls = ($aegisseo_i === $aegisseo_page) ? 'button button-primary button-small' : 'button button-small';
                    ?>
                    <a class="<?php echo esc_attr($aegisseo_cls); ?>" href="<?php echo esc_url($aegisseo_u); ?>"><?php echo esc_html($aegisseo_i); ?></a>
                <?php endfor; ?>
            </div>
        </div>
    <?php endif; ?>
</div>