<?php
if (!defined('ABSPATH')) { exit; }

$aegisseo_opts = aegisseo()->options->get_all();

// Nonce gate for processing query parameters on this admin tab (Plugin Check requirement).
$aegisseo_tab_nonce = isset($_GET['_wpnonce']) ? sanitize_text_field(wp_unslash($_GET['_wpnonce'])) : '';
$aegisseo_tab_nonce_ok = ($aegisseo_tab_nonce !== '') && wp_verify_nonce($aegisseo_tab_nonce, 'aegisseo_redirects_tab');

$aegisseo_saved_raw   = filter_input( INPUT_GET, 'saved', FILTER_UNSAFE_RAW );
$aegisseo_deleted_raw = filter_input( INPUT_GET, 'deleted', FILTER_UNSAFE_RAW );
$aegisseo_error_raw   = filter_input( INPUT_GET, 'error', FILTER_UNSAFE_RAW );
$aegisseo_edit_raw    = filter_input( INPUT_GET, 'edit', FILTER_UNSAFE_RAW );
$aegisseo_from404_raw = filter_input( INPUT_GET, 'from404', FILTER_UNSAFE_RAW );

$aegisseo_edit_id = ( $aegisseo_tab_nonce_ok && null !== $aegisseo_edit_raw ) ? absint( $aegisseo_edit_raw ) : 0;
$aegisseo_from404 = ( $aegisseo_tab_nonce_ok && null !== $aegisseo_from404_raw ) ? sanitize_text_field( wp_unslash( (string) $aegisseo_from404_raw ) ) : '';



$aegisseo_editing = null;
if ($aegisseo_edit_id > 0) {
    $aegisseo_editing = aegisseo()->redirects->get($aegisseo_edit_id);
}

$aegisseo_source_val = '';
$aegisseo_target_val = '';
$aegisseo_match_type_val = 'exact';
$aegisseo_status_val = 301;
$aegisseo_enabled_val = 1;

if ($aegisseo_editing) {
    $aegisseo_source_val = $aegisseo_editing['source'];
    $aegisseo_target_val = $aegisseo_editing['target'];
    $aegisseo_match_type_val = $aegisseo_editing['match_type'];
    $aegisseo_status_val = (int)$aegisseo_editing['status_code'];
    $aegisseo_enabled_val = (int)$aegisseo_editing['enabled'];
} elseif ($aegisseo_from404 !== '') {
    $aegisseo_source_val = $aegisseo_from404;
}

$aegisseo_list = aegisseo()->redirects->list(array('limit' => 100));
?>

<div class="aegisseo-card">
    <h2><?php echo esc_html__('Redirect Manager', 'aegisseo'); ?></h2>
    <p class="description">
        <?php echo esc_html__('Create 301/302/307/410/451 redirects. Supports exact and regex matching. You can also create a redirect directly from a 404 row.', 'aegisseo'); ?>
    </p>

    <?php if ($aegisseo_tab_nonce_ok && null !== $aegisseo_saved_raw): ?>
        <div class="notice notice-success inline"><p><?php echo esc_html__('Redirect saved.', 'aegisseo'); ?></p></div>
    <?php endif; ?>
    <?php if ($aegisseo_tab_nonce_ok && null !== $aegisseo_deleted_raw): ?>
        <div class="notice notice-success inline"><p><?php echo esc_html__('Redirect deleted.', 'aegisseo'); ?></p></div>
    <?php endif; ?>
    <?php if ($aegisseo_tab_nonce_ok && null !== $aegisseo_error_raw): ?>
        <?php $aegisseo_err_msg = sanitize_text_field( rawurldecode( (string) $aegisseo_error_raw ) ); ?>
        <div class="notice notice-error inline"><p><?php echo esc_html($aegisseo_err_msg); ?></p></div>
    <?php endif; ?>

    <h3 style="margin-top: 18px;"><?php echo $aegisseo_editing ? esc_html__('Edit Redirect', 'aegisseo') : esc_html__('Add Redirect', 'aegisseo'); ?></h3>

    <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" class="aegisseo-form">
        <?php wp_nonce_field('aegisseo_redirect_save'); ?>
        <input type="hidden" name="action" value="aegisseo_redirect_save" />
        <input type="hidden" name="id" value="<?php echo esc_attr($aegisseo_edit_id); ?>" />

        <table class="form-table" role="presentation">
            <tr>
                <th scope="row"><label for="aegisseo_source"><?php echo esc_html__('Source', 'aegisseo'); ?></label></th>
                <td>
                    <input id="aegisseo_source" type="text" name="source" class="regular-text" value="<?php echo esc_attr($aegisseo_source_val); ?>" placeholder="/old-page/" />
                    <p class="description"><?php echo esc_html__('Exact: enter a path like /old-page/. Regex: enter a full pattern with delimiters, e.g. #^/old/(.*)$#', 'aegisseo'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="aegisseo_target"><?php echo esc_html__('Target', 'aegisseo'); ?></label></th>
                <td>
                    <input id="aegisseo_target" type="text" name="target" class="regular-text" value="<?php echo esc_attr($aegisseo_target_val); ?>" placeholder="/new-page/" />
                    <p class="description"><?php echo esc_html__('For regex redirects, you may use backrefs like $1 in the target.', 'aegisseo'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row"><?php echo esc_html__('Match Type', 'aegisseo'); ?></th>
                <td>
                    <label><input type="radio" name="match_type" value="exact" <?php checked($aegisseo_match_type_val, 'exact'); ?> /> <?php echo esc_html__('Exact', 'aegisseo'); ?></label>
                    &nbsp;&nbsp;
                    <label><input type="radio" name="match_type" value="regex" <?php checked($aegisseo_match_type_val, 'regex'); ?> /> <?php echo esc_html__('Regex (Advanced)', 'aegisseo'); ?></label>
                </td>
            </tr>
            <tr>
                <th scope="row"><?php echo esc_html__('Redirect Type', 'aegisseo'); ?></th>
                <td>
                    <select name="status_code">
                        <?php foreach (array(301,302,307,410,451) as $aegisseo_sc): ?>
                            <option value="<?php echo esc_attr($aegisseo_sc); ?>" <?php selected($aegisseo_status_val, $aegisseo_sc); ?>><?php echo esc_html($aegisseo_sc); ?></option>
                        <?php endforeach; ?>
                    </select>
                    <p class="description"><?php echo esc_html__('301=Permanent, 302/307=Temporary, 410=Gone, 451=Unavailable for Legal Reasons', 'aegisseo'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row"><?php echo esc_html__('Enabled', 'aegisseo'); ?></th>
                <td>
                    <label><input type="checkbox" name="enabled" value="1" <?php checked($aegisseo_enabled_val, 1); ?> /> <?php echo esc_html__('Active', 'aegisseo'); ?></label>
                </td>
            </tr>
        </table>

        <p>
            <button class="button button-primary"><?php echo esc_html__('Save Redirect', 'aegisseo'); ?></button>
            <?php if ($aegisseo_editing): ?>
                <a class="button button-secondary" href="<?php echo esc_url(admin_url('admin.php?page=aegisseo&tab=redirects')); ?>"><?php echo esc_html__('Cancel', 'aegisseo'); ?></a>
            <?php endif; ?>
        </p>
    </form>

    <h3 style="margin-top: 24px;"><?php echo esc_html__('Existing Redirects', 'aegisseo'); ?></h3>

    <table class="widefat striped">
        <thead>
            <tr>
                <th><?php echo esc_html__('Source', 'aegisseo'); ?></th>
                <th><?php echo esc_html__('Target', 'aegisseo'); ?></th>
                <th style="width:90px;"><?php echo esc_html__('Type', 'aegisseo'); ?></th>
                <th style="width:70px;"><?php echo esc_html__('Status', 'aegisseo'); ?></th>
                <th style="width:80px;"><?php echo esc_html__('Enabled', 'aegisseo'); ?></th>
                <th style="width:140px;"><?php echo esc_html__('Actions', 'aegisseo'); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($aegisseo_list)): ?>
                <tr><td colspan="6"><?php echo esc_html__('No redirects yet.', 'aegisseo'); ?></td></tr>
            <?php else: ?>
                <?php foreach ($aegisseo_list as $aegisseo_r): ?>
                    <tr>
                        <td><code><?php echo esc_html($aegisseo_r['source']); ?></code>
                            <?php if (!empty($aegisseo_r['is_suggestion']) && (int)$aegisseo_r['is_suggestion'] === 1): ?>
                                <span class="aegisseo-badge" style="margin-left:6px; padding:2px 6px; border-radius:10px; background:#f6f7f7; border:1px solid #dcdcde; font-size:11px;">
                                    <?php echo esc_html__('Suggestion', 'aegisseo'); ?>: <?php echo esc_html(!empty($aegisseo_r['suggestion_status']) ? $aegisseo_r['suggestion_status'] : ''); ?>
                                </span>
                            <?php endif; ?>
                        </td>
                        <td><code><?php echo esc_html($aegisseo_r['target']); ?></code></td>
                        <td><?php echo esc_html($aegisseo_r['match_type']); ?></td>
                        <td><?php echo esc_html((int)$aegisseo_r['status_code']); ?></td>
                        <td><?php echo ((int)$aegisseo_r['enabled']===1) ? esc_html__('Yes','aegisseo') : esc_html__('No','aegisseo'); ?></td>
                        <td>
                            <a class="button button-small" href="<?php echo esc_url(admin_url('admin.php?page=aegisseo&tab=redirects&edit='.(int)$aegisseo_r['id'])); ?>"><?php echo esc_html__('Edit', 'aegisseo'); ?></a>
                            <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" style="display:inline;" onsubmit="return confirm('<?php echo esc_js(__('Delete this redirect?', 'aegisseo')); ?>');">
                                <?php wp_nonce_field('aegisseo_redirect_delete'); ?>
                                <input type="hidden" name="action" value="aegisseo_redirect_delete" />
                                <input type="hidden" name="id" value="<?php echo esc_attr((int)$aegisseo_r['id']); ?>" />
                                <button class="button button-small button-secondary" type="submit"><?php echo esc_html__('Delete', 'aegisseo'); ?></button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>
