<?php
if (!defined('ABSPATH')) { exit; }
$aegisseo_opts = aegisseo()->options->get_all();
?>
<div class="wrap aegisseo-wrap">
    <h1><?php echo esc_html__('AegisSEO Setup Wizard', 'aegisseo'); ?></h1>

    <div class="aegisseo-card">
        <p><?php echo esc_html__('This wizard sets your site identity for schema, logos, and social profiles. You can change these later in settings.', 'aegisseo'); ?></p>
    </div>

    <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
        <?php wp_nonce_field('aegisseo_wizard_save'); ?>
        <input type="hidden" name="action" value="aegisseo_wizard_save" />

        <table class="form-table" role="presentation">
            <tr>
                <th scope="row"><?php echo esc_html__('Site Type', 'aegisseo'); ?></th>
                <td>
                    <label><input type="radio" name="site_type" value="organization" <?php checked('organization', $aegisseo_opts['site_type']); ?> /> <?php echo esc_html__('Organization', 'aegisseo'); ?></label>
                    &nbsp;&nbsp;
                    <label><input type="radio" name="site_type" value="person" <?php checked('person', $aegisseo_opts['site_type']); ?> /> <?php echo esc_html__('Person', 'aegisseo'); ?></label>
                </td>
            </tr>

            <tr>
                <th scope="row"><?php echo esc_html__('Organization Name', 'aegisseo'); ?></th>
                <td><input type="text" class="regular-text" name="org_name" value="<?php echo esc_attr($aegisseo_opts['org_name']); ?>" /></td>
            </tr>

            <tr>
                <th scope="row"><?php echo esc_html__('Person Name', 'aegisseo'); ?></th>
                <td><input type="text" class="regular-text" name="person_name" value="<?php echo esc_attr($aegisseo_opts['person_name']); ?>" /></td>
            </tr>

            <tr>
    <th scope="row"><?php echo esc_html__('Home Title Template', 'aegisseo'); ?></th>
    <td>
        <input type="text" class="regular-text" name="title_home" value="<?php echo esc_attr($aegisseo_opts['title_home']); ?>" />
        <p class="description"><?php echo esc_html__('Variables: %%sitename%%, %%tagline%%, %%sep%%', 'aegisseo'); ?></p>
    </td>
</tr>

<tr>
                <th scope="row"><?php echo esc_html__('Logo Attachment ID', 'aegisseo'); ?></th>
                <td>
                    <input type="number" class="small-text" name="logo_id" value="<?php echo esc_attr((int)$aegisseo_opts['logo_id']); ?>" />
                    <p class="description"><?php echo esc_html__('Phase 1 uses an attachment ID for speed; Phase 2 can add a media picker UI.', 'aegisseo'); ?></p>
                </td>
            </tr>

            <tr><th colspan="2"><h2><?php echo esc_html__('Social Profiles', 'aegisseo'); ?></h2></th></tr>
            <tr>
                <th scope="row">Facebook</th>
                <td><input type="url" class="regular-text" name="social_facebook" value="<?php echo esc_attr($aegisseo_opts['social_profiles']['facebook'] ?? ''); ?>" /></td>
            </tr>
            <tr>
                <th scope="row">Twitter/X</th>
                <td><input type="url" class="regular-text" name="social_twitter" value="<?php echo esc_attr($aegisseo_opts['social_profiles']['twitter'] ?? ''); ?>" /></td>
            </tr>
            <tr>
                <th scope="row">Instagram</th>
                <td><input type="url" class="regular-text" name="social_instagram" value="<?php echo esc_attr($aegisseo_opts['social_profiles']['instagram'] ?? ''); ?>" /></td>
            </tr>
            <tr>
                <th scope="row">LinkedIn</th>
                <td><input type="url" class="regular-text" name="social_linkedin" value="<?php echo esc_attr($aegisseo_opts['social_profiles']['linkedin'] ?? ''); ?>" /></td>
            </tr>
            <tr>
                <th scope="row">YouTube</th>
                <td><input type="url" class="regular-text" name="social_youtube" value="<?php echo esc_attr($aegisseo_opts['social_profiles']['youtube'] ?? ''); ?>" /></td>
            </tr>
        </table>

        <?php submit_button(__('Save & Finish', 'aegisseo')); ?>
    </form>

    <div class="aegisseo-footer">
        <p>
            <span><?php echo esc_html__('Powered by Aegisify', 'aegisseo'); ?></span>
            &nbsp;·&nbsp;
            <a href="https://aegisify.com" target="_blank" rel="noopener">aegisify.com</a>
        </p>
    </div>
</div>
