<?php
namespace AegisShield\Admin_Pages;

use AegisShield\AS_Plugin;

defined( 'ABSPATH' ) || exit;

class AS_Page_License {

    protected $plugin;
    protected $free_install_notice = array();
    public function __construct( AS_Plugin $plugin ) {
        $this->plugin = $plugin;
    }
    public function maybe_handle_free_register() {

        if ( ! current_user_can( 'manage_options' ) ) {
            return;
        }

        if ( empty( $_POST['aegisshield_free_install_action'] ) ) {
            return;
        }

        if ( empty( $_POST['aegisshield_free_install_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['aegisshield_free_install_nonce'] ) ), 'aegisshield_free_install' ) ) {
            wp_die( esc_html__( 'Security check failed.', 'aegisshield-security' ) );
        }

        $action  = sanitize_key( wp_unslash( $_POST['aegisshield_free_install_action'] ) );
        $consent = ! empty( $_POST['aegisshield_free_install_consent'] ) ? '1' : '0';

        update_option( 'aegisshield_clm_free_reg_consent', $consent, false );

        if ( 'register' === $action ) {

            if ( '1' !== $consent ) {
                update_option( 'aegisshield_clm_free_reg_last_error', 'Consent not provided.', false );
                wp_safe_redirect( admin_url( 'admin.php?page=aegisshield-license&tab=license&free_install=consent_required' ) );
                exit;
            }

            $ok = function_exists( 'aegisshield_clm_register_free_install' )
                ? (bool) aegisshield_clm_register_free_install()
                : false;

			if ( $ok ) {
				$this->free_install_notice = array(
					'type'    => 'success',
					'message' => __( 'Registered successfully with Aegisify.', 'aegisshield-security' ),
				);
			} else {
				$last_error = (string) get_option( 'aegisshield_clm_free_reg_last_error', '' );
				$this->free_install_notice = array(
					'type'    => 'error',
					'message' => ! empty( $last_error )
						? $last_error
						: __( 'Registration failed. Please try again and check your debug log.', 'aegisshield-security' ),
				);
			}

			return;

        }

        if ( 'unregister' === $action ) {

            if ( function_exists( 'aegisshield_clm_unregister_free_install' ) ) {
                aegisshield_clm_unregister_free_install();
            }

			$this->free_install_notice = array(
				'type'    => 'success',
				'message' => __( 'Unregistered successfully.', 'aegisshield-security' ),
			);

			return;

        }
    }
	protected function log_email_event( $to, $subject, $success, $context = 'test' ) {

		$logs = get_option( 'aegisshield_email_log', array() );
		if ( ! is_array( $logs ) ) {
			$logs = array();
		}

		$logs[] = array(
			'time'    => current_time( 'mysql' ),
			'to'      => sanitize_text_field( $to ),
			'subject' => sanitize_text_field( $subject ),
			'status'  => $success ? 'sent' : 'failed',
			'context' => sanitize_key( $context ),
		);

		if ( count( $logs ) > 50 ) {
			$logs = array_slice( $logs, -50 );
		}

		update_option( 'aegisshield_email_log', $logs );
	}

    public function render() {
        $this->maybe_handle_free_register();

        if ( ! current_user_can( 'manage_options' ) ) {
            wp_die( esc_html__( 'You do not have permission to access this page.', 'aegisshield-security' ) );
        }

        $license_manager = $this->plugin->get_license_manager();
        $license         = $license_manager ? $license_manager->get_license_data() : array();
        $notice          = '';

        if ( $license_manager && isset( $_POST['aegisshield_license_action'] ) && check_admin_referer( 'aegisshield_license_save', 'aegisshield_license_nonce' ) ) {
            $action = isset( $_POST['aegisshield_license_action'] ) ? sanitize_text_field( wp_unslash( $_POST['aegisshield_license_action'] ) ) : '';

            if ( 'activate' === $action ) {
                $license_key = isset( $_POST['aegisshield_license_key'] ) ? sanitize_text_field( wp_unslash( $_POST['aegisshield_license_key'] ) ) : '';
                $email       = isset( $_POST['aegisshield_license_email'] ) ? sanitize_email( wp_unslash( $_POST['aegisshield_license_email'] ) ) : '';

                $result  = $license_manager->activate_license( $license_key, $email );
                $license = $license_manager->get_license_data();
                $notice  = isset( $result['message'] ) ? $result['message'] : '';

            } elseif ( 'deactivate' === $action ) {
                $result  = $license_manager->deactivate_license();
                $license = $license_manager->get_license_data();
                $notice  = isset( $result['message'] ) ? $result['message'] : '';
            }
        }

        $license = is_array( $license ) ? $license : array();

        $status     = isset( $license['status'] ) ? $license['status'] : 'inactive';
		$plan       = isset( $license['plan'] ) ? $license['plan'] : '';
		$expires_at = isset( $license['expires_at'] ) ? $license['expires_at'] : '';
		$suite_pro = ( function_exists( 'aegisify_is_pro' ) && aegisify_is_pro( true ) );
		$is_active  = $license_manager && $license_manager->is_pro_active();

		if ( $suite_pro && '' === (string) $plan ) {
			$plan = 'pro';
		}

        $current_tab = isset( $_GET['tab'] ) ? sanitize_key( wp_unslash( $_GET['tab'] ) ) : 'license';
        $page_url    = admin_url( 'admin.php?page=aegisshield-license' );
        ?>
        <div class="wrap">
            <h1><?php esc_html_e( 'AegisShield License & Upgrades', 'aegisshield-security' ); ?></h1>

            <h2 class="nav-tab-wrapper">
                <a href="<?php echo esc_url( add_query_arg( 'tab', 'license', $page_url ) ); ?>" class="nav-tab <?php echo ( 'license' === $current_tab ) ? 'nav-tab-active' : ''; ?>">
                    <?php esc_html_e( 'License', 'aegisshield-security' ); ?>
                </a>
                <a href="<?php echo esc_url( add_query_arg( 'tab', 'comparison', $page_url ) ); ?>" class="nav-tab <?php echo ( 'comparison' === $current_tab ) ? 'nav-tab-active' : ''; ?>">
                    <?php esc_html_e( 'Free vs Pro Comparison', 'aegisshield-security' ); ?>
                </a>
				<a href="<?php echo esc_url( add_query_arg( 'tab', 'settings', $page_url ) ); ?>" class="nav-tab <?php echo ( 'settings' === $current_tab ) ? 'nav-tab-active' : ''; ?>">
					<?php esc_html_e( 'Email Settings', 'aegisshield-security' ); ?>
				</a>
            </h2>

			<?php if ( ! empty( $notice ) ) : ?>
				<div class="notice notice-info is-dismissible">
					<p><?php echo esc_html( $notice ); ?></p>
				</div>
			<?php endif; ?>

			<?php if ( ! empty( $this->free_install_notice ) && ! empty( $this->free_install_notice['message'] ) ) : ?>
				<div class="notice <?php echo esc_attr( ( $this->free_install_notice['type'] === 'success' ) ? 'notice-success' : 'notice-error' ); ?> is-dismissible">
					<p><?php echo esc_html( $this->free_install_notice['message'] ); ?></p>
				</div>
			<?php endif; ?>

            <?php if ( 'license' === $current_tab ) : ?>

                <h2><?php esc_html_e( 'License Status', 'aegisshield-security' ); ?></h2>

                <div class="notice notice-info aegisshield-upgrade-callout" style="margin-bottom:20px; border-left:4px solid #ff9800;">
                    <p style="font-size:13px; margin:8px 0;">
                        <strong><?php esc_html_e( 'Unlock everything in AegisShield Pro.', 'aegisshield-security' ); ?></strong>
                        <?php esc_html_e( 'Enable advanced malware scanning, real-time alerts, Login Guard Pro, File Integrity Pro, Security Headers Pro, DB Tools Pro and more with a single Pro license.', 'aegisshield-security' ); ?>
                    </p>
                    <p style="margin:8px 0;">
                        <a href="https://aegisify.com/wordpress-aegis-shield-security-product/" target="_blank" class="button button-primary">
                            <?php esc_html_e( 'Upgrade to AegisShield Pro', 'aegisshield-security' ); ?>
                        </a>
                        <span style="margin-left:8px; font-size:12px; opacity:0.85;">
                            <?php esc_html_e( 'Instant download · No long-term contracts', 'aegisshield-security' ); ?>
                        </span>
                    </p>
                </div>

                <table class="widefat striped" style="max-width:600px;margin-bottom:20px;">
                    <tbody>
                        <tr>
                            <th scope="row"><?php esc_html_e( 'Status', 'aegisshield-security' ); ?></th>
                            <td>
                                <?php
                                if ( $is_active ) {
                                    echo '<span style="color:#46b450;font-weight:bold;">' . esc_html__( 'Active (Pro enabled)', 'aegisshield-security' ) . '</span>';
                                } else {
                                    echo '<span style="color:#dc3232;font-weight:bold;">' . esc_html__( 'Inactive', 'aegisshield-security' ) . '</span>';
                                    if ( 'expired' === $status ) {
                                        echo ' &mdash; ' . esc_html__( 'Expired', 'aegisshield-security' );
                                    }
                                }
                                ?>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row"><?php esc_html_e( 'Plan', 'aegisshield-security' ); ?></th>
                            <td><?php echo $plan ? esc_html( $plan ) : '&mdash;'; ?></td>
                        </tr>
                        <tr>
                            <th scope="row"><?php esc_html_e( 'Expires At', 'aegisshield-security' ); ?></th>
                            <td><?php echo $expires_at ? esc_html( $expires_at ) : '&mdash;'; ?></td>
                        </tr>
                    </tbody>
                </table>

                <h2><?php esc_html_e( 'Activate or Update License', 'aegisshield-security' ); ?></h2>
				<h4>
					<?php echo esc_html__( 'Create an account on', 'aegisshield-security' ); ?>
					<a href="<?php echo esc_url( 'https://aegisify.com/register/' ); ?>" target="_blank" rel="noopener noreferrer">
						<?php echo esc_html( 'https://aegisify.com/register/' ); ?>
					</a>
					<?php echo esc_html__( 'and help support Aegisify by buying a license today!', 'aegisshield-security' ); ?>
				</h4>
				<hr />
                <form method="post" action="">
                    <?php wp_nonce_field( 'aegisshield_license_save', 'aegisshield_license_nonce' ); ?>

                    <table class="form-table" style="max-width:600px;">
                        <tr>
                            <th scope="row">
                                <label for="aegisshield_license_key"><?php esc_html_e( 'License Key', 'aegisshield-security' ); ?></label>
                            </th>
                            <td>
                                <input type="text"
                                       id="aegisshield_license_key"
                                       name="aegisshield_license_key"
                                       class="regular-text"
                                       value="<?php echo isset( $license['license_key'] ) ? esc_attr( $license['license_key'] ) : ''; ?>" />
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="aegisshield_license_email"><?php esc_html_e( 'License Email', 'aegisshield-security' ); ?></label>
                            </th>
                            <td>
                                <input type="email"
                                       id="aegisshield_license_email"
                                       name="aegisshield_license_email"
                                       class="regular-text"
                                       value="<?php echo isset( $license['license_email'] ) ? esc_attr( $license['license_email'] ) : ''; ?>" />
                                <p class="description">
                                    <?php esc_html_e( 'Use the email address associated with your AegisShield purchase.', 'aegisshield-security' ); ?>
                                </p>
                            </td>
                        </tr>
                    </table>

                    <p class="submit">
                        <button type="submit" class="button button-primary" name="aegisshield_license_action" value="activate">
                            <?php esc_html_e( 'Activate / Save License', 'aegisshield-security' ); ?>
                        </button>

                        <?php if ( ! empty( $license['license_key'] ) ) : ?>
                            <button type="submit" class="button" name="aegisshield_license_action" value="deactivate">
                                <?php esc_html_e( 'Deactivate License', 'aegisshield-security' ); ?>
                            </button>
                        <?php endif; ?>
                    </p>
                </form>

                <?php
                $is_registered = ( get_option( 'aegisshield_clm_free_reg_done' ) === '1' );
                $consent_opt   = ( get_option( 'aegisshield_clm_free_reg_consent' ) === '1' );
                $last_error    = (string) get_option( 'aegisshield_clm_free_reg_last_error', '' );
                ?>

                <hr />

                <h3 style="margin-top:12px;"><?php esc_html_e( 'Optional: Register this free installation', 'aegisshield-security' ); ?></h3>

                <p style="max-width:980px;">
                    <?php esc_html_e( 'This is optional and if you want update checks and license-related features through Aegisify, you can register this free installation. This will send your site domain, site URL, and the WordPress admin email to Aegisify. Your information will never leave our database nor be sold to any 3rd party.', 'aegisshield-security' ); ?>
                </p>

                <form method="post" action="" style="margin-top:10px;">
                    <?php wp_nonce_field( 'aegisshield_free_install', 'aegisshield_free_install_nonce' ); ?>

                    <label style="display:block; margin:8px 0;">
                        <input type="checkbox"
                               name="aegisshield_free_install_consent"
                               value="1"
                               <?php checked( $consent_opt ); ?> />
                        <?php esc_html_e( 'I consent to send the data described above to Aegisify.', 'aegisshield-security' ); ?>
                    </label>

                    <p style="margin:8px 0;">
                        <strong><?php esc_html_e( 'Registration Status:', 'aegisshield-security' ); ?></strong>
                        <?php if ( $is_registered ) : ?>
                            <span style="color:#46b450; font-weight:700;"><?php esc_html_e( 'Registered', 'aegisshield-security' ); ?></span>
                        <?php else : ?>
                            <span style="color:#666;"><?php esc_html_e( 'Not registered', 'aegisshield-security' ); ?></span>
                        <?php endif; ?>
                    </p>

                    <?php if ( $is_registered ) : ?>
                        <input type="hidden" name="aegisshield_free_install_action" value="unregister" />
                        <button type="submit" class="button">
                            <?php esc_html_e( 'Unregister Free Installation', 'aegisshield-security' ); ?>
                        </button>
                    <?php else : ?>
                        <input type="hidden" name="aegisshield_free_install_action" value="register" />
                        <button type="submit" class="button button-secondary">
                            <?php esc_html_e( 'Register Free Installation', 'aegisshield-security' ); ?>
                        </button>
                    <?php endif; ?>
                </form>

                <hr />


                <h2 style="margin-top:40px;"><?php esc_html_e( 'What You Get With AegisShield Pro', 'aegisshield-security' ); ?></h2>

                <p>
                    <?php esc_html_e( 'AegisShield Pro transforms your WordPress site into a proactive, always-on security system. By combining automation, remote vulnerability intelligence, deeper activity logs, and stronger hardening, Pro keeps your site locked down without requiring constant manual checks.', 'aegisshield-security' ); ?>
                </p>

                <p>
                    <?php esc_html_e( 'With Pro, security becomes automatic. Scheduled scans, alerts, and advanced hardening keep hackers out, detect suspicious changes instantly, and give you full visibility into what is happening inside your site.', 'aegisshield-security' ); ?>
                </p>

                <h3 style="margin-top:25px;"><?php esc_html_e( 'How Pro Hardens WordPress and Stops Hackers at the Front', 'aegisshield-security' ); ?></h3>

                <p>
                    <?php esc_html_e( 'Pro protects the most commonly targeted areas of a WordPress site: the login page, outdated plugins and themes, weak configuration settings, and hidden backdoors created by attackers.', 'aegisshield-security' ); ?>
                </p>

                <p>
                    <?php esc_html_e( 'Your site becomes far harder to compromise because Pro adds strong password enforcement, scheduled file integrity and malware scans, vulnerability monitoring, deeper logs, and enhanced security headers. If an attacker does attempt something, Pro immediately records, alerts, and exposes it.', 'aegisshield-security' ); ?>
                </p>

                <p>
                    <?php esc_html_e( 'By combining Login Guard, Hardening, File Integrity Monitoring, Malware Scanning, Activity Log Pro, and Vulnerability Intelligence, you get security that actively blocks intrusion attempts and gives you clear insights into how attackers operate.', 'aegisshield-security' ); ?>
                </p>

                <p style="margin-top:30px;">
                    <a href="<?php echo esc_url( add_query_arg( 'tab', 'comparison', $page_url ) ); ?>" class="button button-secondary">
                        <?php esc_html_e( 'View Full Free vs Pro Comparison', 'aegisshield-security' ); ?>
                    </a>
                </p>

			<?php elseif ( 'settings' === $current_tab ) : ?>

				<?php

				if (
					isset( $_POST['aegisshield_send_test_email'] )
					&& check_admin_referer( 'aegisshield_mail_settings_save', 'aegisshield_mail_settings_nonce' )
				) {
					$to      = get_option( 'admin_email' );
					$subject = __( 'AegisShield Test Email', 'aegisshield-security' );
					$body    = __( 'This is a test email sent using your configured SMTP settings.', 'aegisshield-security' );

					$sent = false;
					if ( class_exists( '\AegisShield\AS_Notifier' ) ) {
						$notifier = new \AegisShield\AS_Notifier();
						$sent     = $notifier->send_email_to( $to, $subject, $body );
					}

					$this->log_email_event( $to, $subject, (bool) $sent, 'test' );

					if ( $sent ) {
						echo '<div class="notice notice-success is-dismissible"><p>'
							. esc_html__( 'Test email sent successfully.', 'aegisshield-security' )
							. '</p></div>';
					} else {
						echo '<div class="notice notice-error is-dismissible"><p>'
							. esc_html__( 'Test email failed. Check SMTP settings and server connectivity.', 'aegisshield-security' )
							. '</p></div>';
					}
				}

				if (
					isset( $_POST['aegisshield_mail_settings_save'] )
					&& check_admin_referer( 'aegisshield_mail_settings_save', 'aegisshield_mail_settings_nonce' )
				) {
					$settings = array(
						'alert_recipients' => isset( $_POST['as_alert_recipients'] ) ? sanitize_textarea_field( wp_unslash( $_POST['as_alert_recipients'] ) ) : '',
						'smtp_enabled'   => isset( $_POST['as_smtp_enabled'] ) ? 1 : 0,
						'smtp_host'      => isset( $_POST['as_smtp_host'] ) ? sanitize_text_field( wp_unslash( $_POST['as_smtp_host'] ) ) : '',
						'smtp_port'      => isset( $_POST['as_smtp_port'] ) ? absint( wp_unslash( $_POST['as_smtp_port'] ) ) : 0,
						'smtp_username'  => isset( $_POST['as_smtp_username'] ) ? sanitize_text_field( wp_unslash( $_POST['as_smtp_username'] ) ) : '',
						'smtp_password'  => isset( $_POST['as_smtp_password'] ) ? sanitize_text_field( wp_unslash( $_POST['as_smtp_password'] ) ) : '',
						'smtp_encryption'=> isset( $_POST['as_smtp_encryption'] ) ? sanitize_key( wp_unslash( $_POST['as_smtp_encryption'] ) ) : '',
						'smtp_from_email'=> isset( $_POST['as_smtp_from_email'] ) ? sanitize_email( wp_unslash( $_POST['as_smtp_from_email'] ) ) : '',
						'smtp_from_name' => isset( $_POST['as_smtp_from_name'] ) ? sanitize_text_field( wp_unslash( $_POST['as_smtp_from_name'] ) ) : '',

						'imap_enabled'   => isset( $_POST['as_imap_enabled'] ) ? 1 : 0,
						'imap_host'      => isset( $_POST['as_imap_host'] ) ? sanitize_text_field( wp_unslash( $_POST['as_imap_host'] ) ) : '',
						'imap_port'      => isset( $_POST['as_imap_port'] ) ? absint( wp_unslash( $_POST['as_imap_port'] ) ) : 0,
						'imap_username'  => isset( $_POST['as_imap_username'] ) ? sanitize_text_field( wp_unslash( $_POST['as_imap_username'] ) ) : '',
						'imap_password'  => isset( $_POST['as_imap_password'] ) ? sanitize_text_field( wp_unslash( $_POST['as_imap_password'] ) ) : '',
						'imap_encryption'=> isset( $_POST['as_imap_encryption'] ) ? sanitize_key( wp_unslash( $_POST['as_imap_encryption'] ) ) : '',
					);

					update_option( 'aegisshield_mail_settings', $settings );
					echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__( 'Mail settings saved.', 'aegisshield-security' ) . '</p></div>';
				}

				$mail_settings = get_option( 'aegisshield_mail_settings', array() );
				$alert_recipients = $mail_settings['alert_recipients'] ?? '';
				?>

				<h2><?php esc_html_e( 'Mail Delivery Settings (SMTP/IMAP)', 'aegisshield-security' ); ?></h2>

				<p style="max-width:900px; line-height:1.6;">
					<?php esc_html_e( 'Shared hosting often blocks or throttles PHP mail. Configure SMTP to ensure AegisShield can deliver security alerts reliably.', 'aegisshield-security' ); ?>
				</p>

				<form method="post" action="">
					<?php wp_nonce_field( 'aegisshield_mail_settings_save', 'aegisshield_mail_settings_nonce' ); ?>

					<h3><?php esc_html_e( 'Global Alert Recipients', 'aegisshield-security' ); ?></h3>

					<table class="form-table" style="max-width:900px;">
						<tr>
							<th scope="row">
								<label for="as_alert_recipients">
									<?php esc_html_e( 'Alert Recipient Emails', 'aegisshield-security' ); ?>
								</label>
							</th>
							<td>
								<textarea
									id="as_alert_recipients"
									name="as_alert_recipients"
									rows="3"
									class="large-text"
									placeholder="security@yourdomain.com, admin@yourdomain.com"
								><?php echo esc_textarea( $alert_recipients ); ?></textarea>

								<p class="description">
									<?php esc_html_e(
										'Enter one or more email addresses separated by commas. All AegisShield alerts and system notifications will be sent to these addresses. If left empty, WordPress Admin Email will be used.',
										'aegisshield-security'
									); ?>
								</p>
							</td>
						</tr>
					</table>

					<hr style="margin:25px 0;" />

					<h3 style="margin-top:25px;"><?php esc_html_e( 'SMTP (Outgoing Mail)', 'aegisshield-security' ); ?></h3>

					<table class="form-table" style="max-width:900px;">
						<tr>
							<th scope="row"><?php esc_html_e( 'Enable SMTP', 'aegisshield-security' ); ?></th>
							<td>
								<label>
									<input type="checkbox" name="as_smtp_enabled" value="1" <?php checked( (int) ( $mail_settings['smtp_enabled'] ?? 0 ), 1 ); ?> />
									<?php esc_html_e( 'Use an external SMTP server for sending alerts', 'aegisshield-security' ); ?>
								</label>
							</td>
						</tr>

						<tr>
							<th scope="row"><label for="as_smtp_host"><?php esc_html_e( 'SMTP Host', 'aegisshield-security' ); ?></label></th>
							<td><input type="text" id="as_smtp_host" name="as_smtp_host" class="regular-text" value="<?php echo esc_attr( $mail_settings['smtp_host'] ?? '' ); ?>" placeholder="smtp.yourdomain.com" /></td>
						</tr>

						<tr>
							<th scope="row"><label for="as_smtp_port"><?php esc_html_e( 'SMTP Port', 'aegisshield-security' ); ?></label></th>
							<td><input type="number" id="as_smtp_port" name="as_smtp_port" class="small-text" value="<?php echo esc_attr( $mail_settings['smtp_port'] ?? '' ); ?>" placeholder="587" /></td>
						</tr>

						<tr>
							<th scope="row"><label for="as_smtp_username"><?php esc_html_e( 'SMTP Username', 'aegisshield-security' ); ?></label></th>
							<td><input type="text" id="as_smtp_username" name="as_smtp_username" class="regular-text" value="<?php echo esc_attr( $mail_settings['smtp_username'] ?? '' ); ?>" /></td>
						</tr>

						<tr>
							<th scope="row"><label for="as_smtp_password"><?php esc_html_e( 'SMTP Password', 'aegisshield-security' ); ?></label></th>
							<td><input type="password" id="as_smtp_password" name="as_smtp_password" class="regular-text" value="<?php echo esc_attr( $mail_settings['smtp_password'] ?? '' ); ?>" autocomplete="new-password" /></td>
						</tr>

						<tr>
							<th scope="row"><?php esc_html_e( 'Encryption', 'aegisshield-security' ); ?></th>
							<td>
								<select name="as_smtp_encryption">
									<option value="" <?php selected( $mail_settings['smtp_encryption'] ?? '', '' ); ?>><?php esc_html_e( 'None', 'aegisshield-security' ); ?></option>
									<option value="ssl" <?php selected( $mail_settings['smtp_encryption'] ?? '', 'ssl' ); ?>>SSL</option>
									<option value="tls" <?php selected( $mail_settings['smtp_encryption'] ?? '', 'tls' ); ?>>TLS</option>
								</select>
							</td>
						</tr>

						<tr>
							<th scope="row"><label for="as_smtp_from_email"><?php esc_html_e( 'From Email (optional)', 'aegisshield-security' ); ?></label></th>
							<td><input type="email" id="as_smtp_from_email" name="as_smtp_from_email" class="regular-text" value="<?php echo esc_attr( $mail_settings['smtp_from_email'] ?? '' ); ?>" placeholder="alerts@yourdomain.com" /></td>
						</tr>

						<tr>
							<th scope="row"><label for="as_smtp_from_name"><?php esc_html_e( 'From Name (optional)', 'aegisshield-security' ); ?></label></th>
							<td><input type="text" id="as_smtp_from_name" name="as_smtp_from_name" class="regular-text" value="<?php echo esc_attr( $mail_settings['smtp_from_name'] ?? '' ); ?>" placeholder="AegisShield Alerts" /></td>
						</tr>
					</table>

					<hr style="margin:25px 0;" />

					<p class="submit">
						<button type="submit" class="button button-primary" name="aegisshield_mail_settings_save" value="1">
							<?php esc_html_e( 'Save Mail Settings', 'aegisshield-security' ); ?>
						</button>

						<button type="submit" class="button button-secondary" name="aegisshield_send_test_email" value="1" style="margin-left:8px;">
							<?php esc_html_e( 'Send Test Email', 'aegisshield-security' ); ?>
						</button>
					</p>
				</form>
				
				<?php
				$email_logs = get_option( 'aegisshield_email_log', array() );
				if ( ! is_array( $email_logs ) ) {
					$email_logs = array();
				}
				?>

				<?php if ( empty( $email_logs ) ) : ?>
					<p class="description"><?php esc_html_e( 'No email delivery events logged yet. Use "Send Test Email" to generate a log entry.', 'aegisshield-security' ); ?></p>
				<?php else : ?>
				<?php endif; ?>

				<hr style="margin:30px 0;" />

				<h3><?php esc_html_e( 'Email Delivery Log (Last 50)', 'aegisshield-security' ); ?></h3>

				<table class="widefat striped" style="max-width:900px;">
					<thead>
						<tr>
							<th><?php esc_html_e( 'Time', 'aegisshield-security' ); ?></th>
							<th><?php esc_html_e( 'Recipient', 'aegisshield-security' ); ?></th>
							<th><?php esc_html_e( 'Subject', 'aegisshield-security' ); ?></th>
							<th><?php esc_html_e( 'Status', 'aegisshield-security' ); ?></th>
						</tr>
					</thead>
					<tbody>
						<?php foreach ( array_reverse( $email_logs ) as $log ) : ?>
							<tr>
								<td><?php echo esc_html( $log['time'] ?? '' ); ?></td>
								<td><?php echo esc_html( $log['to'] ?? '' ); ?></td>
								<td><?php echo esc_html( $log['subject'] ?? '' ); ?></td>
								<td>
									<?php
									if ( 'sent' === ( $log['status'] ?? '' ) ) {
										echo '<span style="color:#46b450;font-weight:600;">' . esc_html__( 'Sent', 'aegisshield-security' ) . '</span>';
									} else {
										echo '<span style="color:#dc3232;font-weight:600;">' . esc_html__( 'Failed', 'aegisshield-security' ) . '</span>';
									}
									?>
								</td>
							</tr>
						<?php endforeach; ?>
					</tbody>
				</table>

            <?php else : ?>

                <h2><?php esc_html_e( 'AegisShield Security — Free vs Pro Feature Matrix', 'aegisshield-security' ); ?></h2>

                <p style="max-width:800px; line-height:1.6;">
                    <?php esc_html_e(
                        'AegisShield Security is designed for modern WordPress environments — from small blogs running on shared hosting to mission-critical business websites. The Free version gives you strong core protection, while AegisShield Pro unlocks enterprise-grade automation, deeper threat intelligence, real-time alerts, advanced file monitoring, and incident-level visibility that transforms how security is managed.',
                        'aegisshield-security'
                    ); ?>
                </p>

                <p style="max-width:800px; line-height:1.6; margin-bottom:25px;">
                    <?php esc_html_e(
                        'Compare the versions below to see exactly how upgrading to Pro strengthens malware detection, hardens your site, automates security tasks, and surfaces suspicious activity before it becomes a breach.',
                        'aegisshield-security'
                    ); ?>
                </p>

                <div class="notice notice-info aegisshield-upgrade-callout" style="margin-bottom:20px; border-left:4px solid #ff9800;">
                    <p style="font-size:13px; margin:8px 0;">
                        <strong><?php esc_html_e( 'Unlock everything in AegisShield Pro.', 'aegisshield-security' ); ?></strong>
                        <?php esc_html_e( 'Enable advanced malware scanning, real-time alerts, Login Guard Pro, File Integrity Pro, Security Headers Pro, DB Tools Pro and more with a single Pro license.', 'aegisshield-security' ); ?>
                    </p>
                    <p style="margin:8px 0;">
                        <a href="https://aegisify.com/wordpress-aegis-shield-security-product/" target="_blank" class="button button-primary">
                            <?php esc_html_e( 'Upgrade to AegisShield Pro', 'aegisshield-security' ); ?>
                        </a>
                        <span style="margin-left:8px; font-size:12px; opacity:0.85;">
                            <?php esc_html_e( 'Instant download · No long-term contracts', 'aegisshield-security' ); ?>
                        </span>
                    </p>
                </div>

                <style>
                    .as-license-matrix .as-check {
                        color: #46b450;
                        font-weight: 600;
                        font-size: 13px;
                    }
                    .as-license-matrix .as-x {
                        color: #dc3232;
                        font-weight: 600;
                        font-size: 13px;
                    }
                    .as-license-matrix .as-pro-badge {
                        display: inline-block;
                        padding: 1px 6px;
                        margin-left: 4px;
                        border-radius: 3px;
                        background: #ff9800;
                        color: #fff;
                        font-size: 10px;
                        font-weight: 600;
                        text-transform: uppercase;
                    }
                    .as-license-matrix .as-section-header th {
                        background: #2271b1;
                        color: #ffffff;
                        font-weight: 600;
                    }
                    .as-license-matrix .as-pro-row {
                        background: #fff8e1;
                    }
                    .as-license-matrix th,
                    .as-license-matrix td {
                        vertical-align: top;
                    }
                    .as-license-matrix .as-section-header-inner {
                        display: flex;
                        justify-content: space-between;
                        align-items: center;
                        width: 100%;
                    }
                    .as-license-matrix .as-section-title {
                        display: flex;
                        align-items: center;
                        gap: 6px;
                        font-size: 14px;
                    }
                    .as-license-matrix .as-section-title-icon {
                        font-size: 16px;
                    }
                    .as-license-matrix .as-section-right {
                        font-size: 12px;
                        font-weight: 400;
                    }
                </style>

                <table class="widefat striped as-license-matrix" style="border-collapse:collapse;width:100%;max-width:1000px;">
                    <thead>
                        <tr class="as-section-header">
                            <th colspan="3">
                                <div class="as-section-header-inner">
                                    <div class="as-section-title">
                                        <span class="as-section-title-icon">🛡️</span>
                                        <strong><?php esc_html_e( 'Dashboard', 'aegisshield-security' ); ?></strong>
                                    </div>
                                    <div class="as-section-right">
                                        <?php esc_html_e( 'Free', 'aegisshield-security' ); ?>
                                        &nbsp;|&nbsp;
                                        <?php esc_html_e( 'Pro', 'aegisshield-security' ); ?>
                                        <span class="as-pro-badge"><?php esc_html_e( 'Pro', 'aegisshield-security' ); ?></span>
                                    </div>
                                </div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><?php esc_html_e( 'Security overview summary', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'Module status indicators', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'System health summary (basic)', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'Version information', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'Last scan summaries (basic)', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Enhanced system health metrics', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Deep scan summaries (Integrity, Quick Scan, Attack Story)', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Pro module indicators (CSP Builder, Attack Story, etc.)', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                    </tbody>

                    <thead>
                        <tr class="as-section-header">
                            <th colspan="3">
                                <div class="as-section-header-inner">
                                    <div class="as-section-title">
                                        <span class="as-section-title-icon">📜</span>
                                        <strong><?php esc_html_e( 'Activity Log', 'aegisshield-security' ); ?></strong>
                                    </div>
                                    <div class="as-section-right">
                                        <?php esc_html_e( 'Free', 'aegisshield-security' ); ?>
                                        &nbsp;|&nbsp;
                                        <?php esc_html_e( 'Pro', 'aegisshield-security' ); ?>
                                        <span class="as-pro-badge"><?php esc_html_e( 'Pro', 'aegisshield-security' ); ?></span>
                                    </div>
                                </div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><?php esc_html_e( 'Core logging (users, roles, settings)', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'Plugin/theme activation logs', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'Basic filtering', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'Basic retention', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'Column sorting', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Export logs (CSV/JSON)', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Advanced filtering', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Extended retention', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Alert Rules Engine (UI + logic)', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Email alerts based on event rules', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Integration: Login Guard events', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Integration: File Integrity alerts', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Integration: Malware Scan alerts', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Integration: MFA events', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>


                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Sessions UI (placeholder, Pro)', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                    </tbody>

                    <thead>
                        <tr class="as-section-header">
                            <th colspan="3">
                                <div class="as-section-header-inner">
                                    <div class="as-section-title">
                                        <span class="as-section-title-icon">🔐</span>
                                        <strong><?php esc_html_e( 'Login Guard', 'aegisshield-security' ); ?></strong>
                                    </div>
                                    <div class="as-section-right">
                                        <?php esc_html_e( 'Free', 'aegisshield-security' ); ?>
                                        &nbsp;|&nbsp;
                                        <?php esc_html_e( 'Pro', 'aegisshield-security' ); ?>
                                        <span class="as-pro-badge"><?php esc_html_e( 'Pro', 'aegisshield-security' ); ?></span>
                                    </div>
                                </div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><?php esc_html_e( 'Basic brute-force protection', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'Failed login logging', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Custom lockout rules', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Enhanced rate limiting', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Email alerts on lockouts', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'IP blocklist', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'IP allowlist', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Temporary lockout overrides', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Integration: Alert Rules', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Integration: Attack Story', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Session/device anomaly detection (hooks)', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                    </tbody>

                    <thead>
                        <tr class="as-section-header">
                            <th colspan="3">
                                <div class="as-section-header-inner">
                                    <div class="as-section-title">
                                        <span class="as-section-title-icon">📲</span>
                                        <strong><?php esc_html_e( 'Multi-Factor Authentication (MFA)', 'aegisshield-security' ); ?></strong>
                                    </div>
                                    <div class="as-section-right">
                                        <?php esc_html_e( 'Free', 'aegisshield-security' ); ?>
                                        &nbsp;|&nbsp;
                                        <?php esc_html_e( 'Pro', 'aegisshield-security' ); ?>
                                        <span class="as-pro-badge"><?php esc_html_e( 'Pro', 'aegisshield-security' ); ?></span>
                                    </div>
                                </div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><?php esc_html_e( 'MFA engine & secure storage', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'MFA enrollment UI', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'Offline QR enrollment & backup codes', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'Email-based MFA', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Role-based MFA enforcement', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Mandatory MFA for administrators', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'MFA enforcement policies', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'MFA event logging & alerts', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Integration with Login Guard & Alert Rules', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                    </tbody>

                    <thead>
                        <tr class="as-section-header">
                            <th colspan="3">
                                <div class="as-section-header-inner">
                                    <div class="as-section-title">
                                        <span class="as-section-title-icon">🗂️</span>
                                        <strong><?php esc_html_e( 'File Integrity', 'aegisshield-security' ); ?></strong>
                                    </div>
                                    <div class="as-section-right">
                                        <?php esc_html_e( 'Free', 'aegisshield-security' ); ?>
                                        &nbsp;|&nbsp;
                                        <?php esc_html_e( 'Pro', 'aegisshield-security' ); ?>
                                        <span class="as-pro-badge"><?php esc_html_e( 'Pro', 'aegisshield-security' ); ?></span>
                                    </div>
                                </div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><?php esc_html_e( 'Core checksum baselines', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'Detect new/modified/deleted files', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'Basic exclude list', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Custom directories for monitoring', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Advanced exclude patterns', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Severity badges (Low/Med/High)', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Incident-aware monitoring', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Email alerts for high-risk changes', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Incremental Quick Scan integration', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'View diff (UI placeholder)', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                    </tbody>

                    <thead>
                        <tr class="as-section-header">
                            <th colspan="3">
                                <div class="as-section-header-inner">
                                    <div class="as-section-title">
                                        <span class="as-section-title-icon">🧱</span>
                                        <strong><?php esc_html_e( 'Hardening', 'aegisshield-security' ); ?></strong>
                                    </div>
                                    <div class="as-section-right">
                                        <?php esc_html_e( 'Free', 'aegisshield-security' ); ?>
                                        &nbsp;|&nbsp;
                                        <?php esc_html_e( 'Pro', 'aegisshield-security' ); ?>
                                        <span class="as-pro-badge"><?php esc_html_e( 'Pro', 'aegisshield-security' ); ?></span>
                                    </div>
                                </div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><?php esc_html_e( 'Disable file editing', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'Disable XML-RPC', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'Hide WordPress version', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'Block author scans', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Strong password enforcement (roles)', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Extended hardening rules', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Hardening changes logged', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Integration with Login Guard', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Integration with Security Headers Profiles', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                    </tbody>

                    <thead>
                        <tr class="as-section-header">
                            <th colspan="3">
                                <div class="as-section-header-inner">
                                    <div class="as-section-title">
                                        <span class="as-section-title-icon">🧩</span>
                                        <strong><?php esc_html_e( 'Security Headers', 'aegisshield-security' ); ?></strong>
                                    </div>
                                    <div class="as-section-right">
                                        <?php esc_html_e( 'Free', 'aegisshield-security' ); ?>
                                        &nbsp;|&nbsp;
                                        <?php esc_html_e( 'Pro', 'aegisshield-security' ); ?>
                                        <span class="as-pro-badge"><?php esc_html_e( 'Pro', 'aegisshield-security' ); ?></span>
                                    </div>
                                </div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><?php esc_html_e( 'Basic header management', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'Basic HSTS', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'Basic X-Frame-Options', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'Basic Referrer-Policy', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'Basic Permissions-Policy', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'CSP Builder Pro (UI shown, dimmed)', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Profiles & Health Pro (UI shown, dimmed)', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Advanced HSTS (subdomains, preload, max-age)', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Per-directive CSP control', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Advanced Referrer-Policy', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Advanced Permissions-Policy', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Security Profiles (Relaxed / Balanced / Strict)', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Header templates', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Integration with Activity Log & Alerts', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                    
                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'CSP report-only mode & violation logging', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'CSP recommendations from violations', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

</tbody>

                    <thead>
                        <tr class="as-section-header">
                            <th colspan="3">
                                <div class="as-section-header-inner">
                                    <div class="as-section-title">
                                        <span class="as-section-title-icon">🧪</span>
                                        <strong><?php esc_html_e( 'Malware Scan', 'aegisshield-security' ); ?></strong>
                                    </div>
                                    <div class="as-section-right">
                                        <?php esc_html_e( 'Free', 'aegisshield-security' ); ?>
                                        &nbsp;|&nbsp;
                                        <?php esc_html_e( 'Pro', 'aegisshield-security' ); ?>
                                        <span class="as-pro-badge"><?php esc_html_e( 'Pro', 'aegisshield-security' ); ?></span>
                                    </div>
                                </div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><?php esc_html_e( 'Full scan (themes/plugins/uploads)', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'Basic heuristic detection', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'Basic malware report', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Custom directories for scanning', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Extended heuristic engine', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Incremental Quick Scan (changed files only)', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Attack Story (timeline view)', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Email alerts on infected files', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Scheduled malware scans', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Scan metadata (type, file count, suspect count)', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Integration with File Integrity Monitor', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Integration with Alert Engine', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                    </tbody>

                    <thead>
                        <tr class="as-section-header">
                            <th colspan="3">
                                <div class="as-section-header-inner">
                                    <div class="as-section-title">
                                        <span class="as-section-title-icon">🗃️</span>
                                        <strong><?php esc_html_e( 'Database Tools', 'aegisshield-security' ); ?></strong>
                                    </div>
                                    <div class="as-section-right">
                                        <?php esc_html_e( 'Free', 'aegisshield-security' ); ?>
                                        &nbsp;|&nbsp;
                                        <?php esc_html_e( 'Pro', 'aegisshield-security' ); ?>
                                        <span class="as-pro-badge"><?php esc_html_e( 'Pro', 'aegisshield-security' ); ?></span>
                                    </div>
                                </div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><?php esc_html_e( 'Table overview', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'Row/size breakdown', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'Manual optimize', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'Basic repair tools', 'aegisshield-security' ); ?></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Table growth monitoring', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Database prefix manager', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Export database summary', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Scheduled optimization (WP-Cron)', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Pagination options (25/50/100)', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Activity Log integration for DB events', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                    
                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Database backup before prefix change', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Prefix change preview (dry-run)', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Internal prefix-bound key updates', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>
                        <tr class="as-pro-row">
                            <td><strong><?php esc_html_e( 'Prefix rollback & restore', 'aegisshield-security' ); ?></strong></td>
                            <td style="text-align:center;"><span class="as-x">✖</span></td>
                            <td style="text-align:center;"><span class="as-check">✔</span></td>
                        </tr>

</tbody>

                </table>

            <?php endif; ?>
        </div>
        <?php
    }

}
