<?php
namespace AegisShield;

use AegisShield\Alerts\AS_Alert_Engine;


defined( 'ABSPATH' ) || exit;

class AS_Logger {

    public function log( $type, $message, $context = array() ) {
        global $wpdb;

        $table = $this->get_table_name();

        $user_id = get_current_user_id();
		$ip = isset( $_SERVER['REMOTE_ADDR'] ) ? sanitize_text_field( wp_unslash( $_SERVER['REMOTE_ADDR'] ) ) : '';

		if ( empty( $ip ) && is_array( $context ) ) {
			if ( ! empty( $context['ip_address'] ) ) {
				$ip = sanitize_text_field( (string) $context['ip_address'] );
			} elseif ( ! empty( $context['ip'] ) ) {
				$ip = sanitize_text_field( (string) $context['ip'] );
			}
		}

        if ( is_array( $message ) || is_object( $message ) ) {
            $message = wp_json_encode( $message );
        } elseif ( null === $message ) {
            $message = '';
        } else {
            $message = (string) $message;
        }

        $data = array(
            'event_time' => current_time( 'mysql', true ),
            'user_id'    => $user_id,
            'ip_address' => $ip,
            'event_type' => sanitize_key( $type ),
            'message'    => wp_kses_post( $message ),
            'context'    => wp_json_encode( $context ),
        );

        $wpdb->insert( $table, $data ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Direct DB access is required for custom tables; caching handled where appropriate.

$insert_id = isset( $wpdb->insert_id ) ? (int) $wpdb->insert_id : 0;

$event_type = sanitize_key( $type );
if ( $event_type ) {
    $username = '';
    if ( $user_id > 0 ) {
        $user = get_userdata( $user_id );
        if ( $user && ! is_wp_error( $user ) ) {
            $username = $user->user_login;
        }
    }

    $event = array(
        'id'         => $insert_id,
        'event_type' => $event_type,
        'message'    => $message,
        'details'    => $context,
        'user_id'    => $user_id,
        'username'   => $username,
        'ip'         => $ip,
        'timestamp'  => isset( $data['event_time'] ) ? $data['event_time'] : current_time( 'mysql' ),
    );

    do_action( 'aegisshield_log_event_inserted', $event );
}


        $this->maybe_trigger_alerts( $type, $message, $context, $data );
    }

    protected function maybe_trigger_alerts( $type, $message, $context, $data ) {

        // Build a normalized event payload and hand off to the alert engine.
        if ( ! class_exists( AS_Alert_Engine::class ) ) {
            return;
        }

        $event_type = sanitize_key( $type );
        if ( ! $event_type ) {
            return;
        }

        $user_id  = isset( $data['user_id'] ) ? (int) $data['user_id'] : 0;
        $username = '';
        if ( $user_id > 0 ) {
            $user = get_userdata( $user_id );
            if ( $user && ! is_wp_error( $user ) ) {
                $username = $user->user_login;
            }
        }

        $ip        = isset( $data['ip_address'] ) ? $data['ip_address'] : '';
        $timestamp = isset( $data['event_time'] ) ? $data['event_time'] : current_time( 'mysql' );

        $event = array(
            'event_type' => $event_type,
            'message'    => $message,
            'details'    => $context,
            'user_id'    => $user_id,
            'username'   => $username,
            'ip'         => $ip,
            'timestamp'  => $timestamp,
        );

        AS_Alert_Engine::check_rules( $event );
    }

    public function get_table_name() {
        global $wpdb;
        return $wpdb->prefix . 'aegisshield_activity_log';
    }

    public function prune( $days = 30 ) {
        global $wpdb;
        $table = $this->get_table_name();

        $days = absint( $days );
        if ( $days <= 0 ) {
            return;
        }

        $wpdb->query( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Direct DB access is required for custom tables; caching handled where appropriate.
            $wpdb->prepare(
                "DELETE FROM %i WHERE event_time < ( NOW() - INTERVAL %d DAY )",
                $table,
                absint( $days )
            )
        );
    }
}