<?php
namespace AegisShield\Helpers;

defined( 'ABSPATH' ) || exit;

class AS_Login_MFA_Shortcode {

    public static function register() {
        add_shortcode( 'aegis_login_mfa', array( __CLASS__, 'render' ) );
    }

    public static function render() {

        if ( is_user_logged_in() ) {
            return '<p>You are already logged in.</p>';
        }

        $error = '';

		if ( isset( $_POST['aegis_login_submit'] ) ) {

			$nonce = isset( $_POST['aegisshield_login_mfa_nonce'] ) ? sanitize_text_field( wp_unslash( $_POST['aegisshield_login_mfa_nonce'] ) ) : '';
			if ( empty( $nonce ) || ! wp_verify_nonce( $nonce, 'aegisshield_login_mfa' ) ) {
				$error = __( 'Security check failed. Please try again.', 'aegisshield-security' );
			} else {

			$username = isset( $_POST['aegis_username'] ) ? sanitize_user( wp_unslash( $_POST['aegis_username'] ) ) : '';
			
			$password = isset( $_POST['aegis_password'] ) ? sanitize_text_field( wp_unslash( $_POST['aegis_password'] ) ) : '';

			$creds = array(
				'user_login'    => $username,
				'user_password' => $password,
				'remember'      => true,
			);

            $user = wp_signon( $creds, false );

            if ( is_wp_error( $user ) ) {
                $error = $user->get_error_message();
            } else {
                wp_safe_redirect( home_url() );
                exit;
            }
        }
        }

        ob_start();
        ?>
        <style>
            .aegis-form {
                width: 100%;
                max-width: 420px;
                margin: 0 auto;
                padding: 20px;
                border: 1px solid #ddd;
                border-radius: 6px;
                background: #fff;
            }
            .aegis-form label {
                display: block;
                font-weight: 600;
                margin-bottom: 6px;
            }
            .aegis-form input {
                width: 100%;
                padding: 10px;
                margin-bottom: 14px;
                border: 1px solid #ccc;
                border-radius: 4px;
            }
            .aegis-form button {
                width: 100%;
                padding: 12px;
                font-weight: 600;
            }
            .aegis-links {
                display: flex;
                justify-content: space-between;
                font-size: 13px;
                margin-top: 10px;
            }
            .aegis-error {
                color: #b00020;
                margin-bottom: 10px;
            }
        </style>

        <form method="post" class="aegis-form">
		<?php wp_nonce_field( 'aegisshield_login_mfa', 'aegisshield_login_mfa_nonce' ); ?>
            <?php if ( $error ) : ?>
                <div class="aegis-error"><?php echo wp_kses_post( $error ); ?></div>
            <?php endif; ?>

            <label>Username</label>
            <input type="text" name="aegis_username" required>

            <label>Password</label>
            <input type="password" name="aegis_password" required>

            <label>Authentication Code</label>
            <input type="text"
                   name="aegisshield_2fa_code"
                   inputmode="numeric"
                   pattern="[0-9]{6}"
                   placeholder="6-digit code">

            <button type="submit" name="aegis_login_submit">Secure Login</button>

            <div class="aegis-links">
                <a href="<?php echo esc_url( wp_lostpassword_url() ); ?>">Forgot Password</a>
                <a href="<?php echo esc_url( admin_url( 'profile.php' ) ); ?>">Reset Authentication Code</a>
            </div>
        </form>
        <?php
        return ob_get_clean();
    }
}