
<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class AS_Intelligence_Engine {

    protected static $instance = null;

    public static function instance() {
        if ( self::$instance === null ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        add_action( 'aegisshield_log_event_inserted', array( $this, 'evaluate_intelligence' ), 10, 1 );
    }

    public function evaluate_intelligence( $event ) {
        if ( empty( $event['event_key'] ) ) {
            return;
        }

        $rules = AS_Intel_Rules::get_rules();

        foreach ( $rules as $rule_key => $rule ) {
            if ( call_user_func( array( $this, $rule['callback'] ), $event ) ) {
                $this->emit_intel_event( $rule_key, $event );
            }
        }
    }

    protected function emit_intel_event( $intel_key, $source_event ) {
        if ( ! class_exists( 'AS_Logger' ) ) {
            return;
        }

        AS_Logger::log_event(
            $intel_key,
            'intelligence',
            array(
                'source_event' => $source_event['event_key'],
                'source_id'    => isset( $source_event['id'] ) ? $source_event['id'] : null,
            ),
            'high'
        );
    }

    protected function privilege_escalation( $event ) {
        return in_array( $event['event_key'], array( 'admin_role_changed', 'admin_user_created' ), true );
    }

    protected function mfa_weakened_then_accessed( $event ) {
        return $event['event_key'] === 'login_new_ip';
    }

    protected function core_tampering_pattern( $event ) {
        return in_array( $event['event_key'], array( 'file_integrity_modified', 'file_integrity_deleted' ), true );
    }

    protected function database_risk_chain( $event ) {
        return strpos( $event['event_key'], 'db_' ) === 0;
    }

    protected function security_regression_cluster( $event ) {
        return $event['event_key'] === 'hardening_disabled';
    }

    protected function silent_attack_detected( $event ) {
        return in_array( $event['event_key'], array( 'file_integrity_modified', 'file_integrity_deleted' ), true );
    }
}